﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Threading;
using System.Runtime.CompilerServices;
using System.Runtime.Remoting.Contexts;


/* protecting methods by using the MethodImplAttribute  */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
            synContext = WindowsFormsSynchronizationContext.Current;

            for (int i = 0; i < 1000000; i++)       // initialize list values
                list.Add((double)i);
        }

        object syncRoot = new object();
        SynchronizationContext synContext;
        ArrayList list = new ArrayList();
        Thread t = null;


        /* a helper class just to convey info through the SynchronizationContext.Send() method */
        public class ExecInfo
        {
            int threadID;
            double total;

            public ExecInfo(int ThreadID, double Total)
            {
                this.threadID = ThreadID;
                this.total = Total;
            }

            public override string ToString()
            {
                return "Thread ID: " + threadID.ToString() + ", total: " + total.ToString();
            }
        }

        /* the thread procedure */
        void ThreadProc()
        {
            double total = SumList();

            /* each thread is assigned a unique ID by the system.
               The Thread.CurrentThread static property returns the currently executed thread
               while the Thread.ManagedThreadId instance property returns that unique ID */
            synContext.Send(SynchronizedMethod, new ExecInfo(Thread.CurrentThread.ManagedThreadId, total));
        }

        [MethodImpl(MethodImplOptions.Synchronized)]
        double SumList()
        {
            double total = 0;

            for (int i = 0; i < list.Count; i++)
                total += (double)list[i];

            return total;                
        }

        [MethodImpl(MethodImplOptions.Synchronized)]
        void AlterList()
        {
            for (int i = 0; i < list.Count; i++)
                list[i] = ((double)list[i]) / 2.0;                
        } 

        void SynchronizedMethod(object state)
        {
            textBox1.Text += state.ToString() + Environment.NewLine;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if ((t == null) || (!t.IsAlive))
            {
                t = new Thread(ThreadProc);
                t.Start();

                /* alter list values
                   at the same time, the thread t tries to sum the list */
                AlterList();

                /* a method is executed in a thread context 
                   ThreadProc() is executed twice by this application, and in two different thread contexts: 
                   once for the primary thread and once for the t thread */
                ThreadProc();
            }
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = (t != null) && (t.IsAlive);

            if (e.Cancel)
                MessageBox.Show("Please wait! A thread is still executed...");

            
        }
    }
}



namespace Lessons
{
    /* this class explicitly protects its members */
    public class Coords
    {
        private object syncRoot = new object();

        private int x = 0;
        private int y = 0;

        public int X 
        {
            get { lock (syncRoot) { return x; } }
            set { lock (syncRoot) { x = value; } }
        }

        public int Y
        {
            get { lock (syncRoot) { return y; } }
            set { lock (syncRoot) { y = value; } }
        }
    }

    /* this class defines a synchronized context. All of its members are synchronized.
       No explicit member protection is required */
    [Synchronization()]
    public class SyncCoords: ContextBoundObject
    {

        private int x = 0;
        private int y = 0;

        public int X
        {
            get { { return x; } }
            set { { x = value; } }
        }

        public int Y
        {
            get { { return y; } }
            set { { y = value; } }
        }
    }
}